// Copyright 2000, 2001, 2002, 2003 Macromedia, Inc. All rights reserved.

// *** add case where no sets defined
var DEBUG_FILE = dw.getConfigurationPath() + '/SHORTCUT_DEBUG.txt';

//*************** GLOBALS *****************
var helpDoc = MM.HELP_cmdKeyboardShortcuts;
var ultraDevMenuStr = "ultradev";
var PLATFORM = navigator.platform;
var OPP_PLATFORM = (PLATFORM == "Win32") ? "mac" : "win";  // Opposite platform
var CTRL_STR = (PLATFORM == "Win32") ? "Ctrl" : "Cmd";
var NEWLINE = (PLATFORM != "Win32") ? "\x0D" : "\x0D\x0A";
var FILE_CONFIG_PATH = dw.getConfigurationPath();
var FILE_MENUXML_PATH   = null;
var FILE_CUSTOM_SET = FILE_CONFIG_PATH + "/Menus/Custom Sets";
var FILE_ACTIVE_SET = FILE_CUSTOM_SET + "/active set.txt";
var ARRAY_COMMANDS_TREE = new Array();
var ARRAY_COMMANDS_TREENODES = new Array();
var ARRAY_CUSTOM_SETS;
var ACTIVE_SHORTCUT_LIST = new ShortcutList();   // ShortcutList() class defined in Shortcut.js
var CURRENT_SHORTCUT_LIST = new ShortcutList();
var MENU_DOM = null;
var TREE_CONTROL_WIDTH = 'style="width:345px"';
var TREE_COLUMN_ITEM_WIDTH = 'width="158"';
var TREE_COLUMN_ITEM_WIDTH_MAC = 'width="220"'
var TREE_COLUMN_KEY_WIDTH = 'width="140"';
var SEPARATOR_STR = "-----------------------------------------------";
var ACTIVE_SET_STR;
var YIELD_PATH = "../Shared/MM/Images/yield.gif";
var STOP_PATH = "../Shared/MM/Images/stop.gif";
var ALT_STR = (PLATFORM == "Win32") ? "Alt" : "Opt";
var CONFLICT_ID="";
var CAN_APPLY=true;
var LEFT_LAYER = 'left:235px;';
var RIGHT_LAYER = 'left:321px;';
var TOP_LAYER = 'top:402px;';
var LAST_VALID_COMMAND_MI = "";  //last valid command menu item
var MODIFIER_KEYS = new Array("Ctrl","Cmd","Alt","Opt","Shift");
var SNIPPETS_MODIFIED = false;
// UI Globals
var IBTN_duplicateBtn, IBTN_renameBtn, IBTN_saveAsTextBtn, IBTN_deleteBtn,IBTN_addBtn;
//******************* API **********************

function loadGlobals()
  {
  if (FILE_MENUXML_PATH != null &&
    MENU_DOM != null)
    return;

  FILE_MENUXML_PATH = dw.getMenuFile();
  FILE_SNIPPETSXML_PATH = dw.getSnippetsFile();
  MENU_DOM = dw.getDocumentDOM(FILE_MENUXML_PATH);
  }

function cmdOK()
{
  checkLockedFiles();
  if (document.newShortcutEntry.value && !isSet(MENU_CURRENT_SET.getValue(), "factory"))
    updateUI("applyButton");
  var activeSet = CURRENT_SHORTCUT_LIST.shortcutListName;
  if (!isSet(MENU_CURRENT_SET.getValue(), "factory"))
    CURRENT_SHORTCUT_LIST.writeToShortcutXML(FILE_CUSTOM_SET+"/"+ MENU_CURRENT_SET.getValue(), CURRENT_SHORTCUT_LIST.shortcutListName);
  window.close();
  dreamweaver.runCommand("Processing.htm",CURRENT_SHORTCUT_LIST,FILE_ACTIVE_SET,activeSet,document);
  if(SNIPPETS_MODIFIED)
	dw.snippetPalette.reloadSnippetList();
}

function editMenuXML(shortcutList,activeSetPath,activeSet)
{
  writeToMenusXML(shortcutList);
  DWfile.write(activeSetPath, activeSet);
  dreamweaver.reloadMenus();
}

function cmdCancel()
{
  window.close();
}

function cmdSaveAsText()
{
  var browseURL;
  browseURL = dreamweaver.browseForFileURL("save",LABEL_SaveAsHTML);
  if (browseURL)
  {
  if(browseURL.lastIndexOf(".htm")== -1)
    browseURL +=".htm";
  DWfile.write(browseURL, createHTMLContents());
  }
}

//***************** LOCAL FUNCTIONS  ******************

function initializeUI()
{
  var  i, commandsArray, menuLabel;

  if(checkLockedFiles())
  {
    window.close();
    return;
  }

  // Global UI Controls
  MENU_CURRENT_SET = new ListControl("selectCurrentSet");
  MENU_COMMANDS = new ListControl("commandsList");
  LIST_SHORTCUTS = new ListControl("itemList");
  IBTN_duplicateBtn = new ImageButton("duplicateBtn","IBTN_duplicateBtn","sS",false);
  IBTN_renameBtn = new ImageButton("renameBtn","IBTN_renameBtn","sS",false);
  IBTN_saveAsTextBtn = new ImageButton("saveAsTextBtn","IBTN_saveAsTextBtn","sS",false);
  IBTN_deleteBtn = new ImageButton("deleteBtn","IBTN_deleteBtn","sS",false);
  IBTN_addBtn = new ImageButton("addBtn","IBTN_addBtn","sS",false);
  IBTN_minusBtn = new ImageButton("minusBtn","IBTN_minusBtn","sS",false);
  //
  setCurrentSetMenu();
  // select the active set
  MENU_CURRENT_SET.setIndex(getIndexOfItem(MENU_CURRENT_SET.get('all'),ACTIVE_SET_STR));
  LAST_VALID_COMMAND_MI = MENU_CURRENT_SET.getValue();
  if (PLATFORM == "Win32"){
    if (dw.isMDI()){
      commandsArray = new Array(LABEL_MainMenu, LABEL_SitePanel, SEPARATOR_STR, LABEL_HTMLWindow, LABEL_MainWindow, LABEL_SiteWindow, LABEL_Snippets );
    }else{
      commandsArray = new Array(LABEL_MainMenu, LABEL_SiteMenu, SEPARATOR_STR, LABEL_HTMLWindow, LABEL_MainWindow, LABEL_SiteWindow, LABEL_Snippets );
    }
  }else{
    commandsArray = new Array(LABEL_MainMenu,SEPARATOR_STR, LABEL_HTMLWindow, LABEL_MainWindow, LABEL_Snippets);
  }
  MENU_COMMANDS.setAll(commandsArray,commandsArray);
  MENU_COMMANDS.setIndex(0);

  // create treenode array
  for (i=0; i < MENU_COMMANDS.getLen(); i++)
  {
    menuLabel = MENU_COMMANDS.get(i);
    if (menuLabel == LABEL_MainMenu)
    ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("menubar","DWMainWindow", ""));
  else if (menuLabel == LABEL_SiteMenu)
    ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("menubar","DWMainSite", ""));
  else if (menuLabel == LABEL_SitePanel)
    ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("menubar","DWSitePseudoMenu", ""));
  else if (menuLabel == LABEL_HTMLWindow)
    ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("shortcutlist","DWHTMLContext", "Snippets"));
  else if (menuLabel == LABEL_MainWindow)
    ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("shortcutlist","DWMainWindow", ""));
  else if (menuLabel == LABEL_SiteWindow)
    ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("shortcutlist","DWMainSite", ""));
  else if (menuLabel == LABEL_Snippets)
	//ARRAY_COMMANDS_TREENODES.push(readFromMenuXML("shortcutlist","DWMainSite", ""));*/
    ARRAY_COMMANDS_TREENODES.push(readFromSnippetsXML());
  else
    ARRAY_COMMANDS_TREENODES.push( "-");
  }

  generateTreeArray();

  setCommands();
  // ** compare active and current set
  CURRENT_SHORTCUT_LIST.shortcutListName = ACTIVE_SET_STR;
  setShortcutList();
	MENU_CURRENT_SET.focus();

}

function adjustButtons()
{
  if (PLATFORM=="Win32")
  {
	document.leftBtn.innerHTML = '<input type="button" name="okBtn" value=' + MM.BTN_OK + ' style="width:75px;height:21px" onClick="cmdOK()">';
	document.middleBtn.innerHTML = '<input type="button" name="cancelBtn" value=' + MM.BTN_Cancel + ' style="width:75px;height:21px" onClick="cmdCancel()">';
    document.rightBtn.innerHTML = '<input type="button" name="helpBtn" value=' + MM.BTN_Help + ' style="width:75px;height:21px" onClick="displayHelp()">';
  }
}

// getCustomSetList
// gets the list of custom sets. in DW4, this function returned a single array of
// filenames. it now returns an array containing two items: an array of set names,
// and an array of set filenames. this is so the set names can be localized independent
// of the filenames.
function getCustomSetList(setType)
{
  var fileObj = new File(FILE_CUSTOM_SET);
  var fileArray = new Array();
  var setNames = new Array();
  var filterFunction;
  var setDOM, setName;
  if (setType == "factory")
    filterFunction =  new Function("x", "return (x.isFile()) && ((x.getAttributes() == 'R') || (x.getContents().indexOf('factory') != -1)) && (x.getExtension()== 'xml');");
  else
    filterFunction =  new Function("x", "return (x.isFile()) && ((x.getAttributes() != 'R') && (x.getContents().indexOf('factory') == -1)) && (x.getExtension()== 'xml');");
  fileArray = fileObj.listFolder(filterFunction);
  
  for (var i=0; i < fileArray.length; i++){
    setDOM = dw.getDocumentDOM(FILE_CUSTOM_SET + "/" + fileArray[i]);
    setName = setDOM.getElementsByTagName('SHORTCUTSET')[0].getAttribute('name');
    setNames.push(setName);
  }
  return new Array(setNames,fileArray);
}

// function that walks through the files in the snippets folder to get tree
function readFromSnippetsXML()
{
  var snippetsFile;
  var snippetsList;
  var tempArray = new Array;

  snippetsList = MENU_DOM.getElementsByTagName("snippets");
  
  // Call into the C++ layer to read the index.xml file into our desired html 
  // This call traverses the snippet tags in the snippets node and creates treenodes
  // Returns an object with nodes, and parallel arrays of nodenames and keys
  
  //******************TODO*********************//
  // var treeData = null;//dw.getSnippetsTree(FOLDER_SNIPPETS_PATH);
  var treeData = dw.getSnippetsTree(FILE_MENUXML_PATH);
  
  // It's possible in theory, although highly unlikely, to get NULL back from getMenuTree(),
  // so fail gracefully and return an empty list, and bypass adding stuff to the shortcut list

  if(treeData == null)
	return (new Array());
    
  var nodes = treeData.nodes;
  
  // Use the nodename and keys stuff from the C++ call to populate our shortcutlists too
  addShortcutsFromTree(treeData);

  return nodes;  
}

// function reads in menus.xml and creates the treecontrol
function readFromMenuXML(tagName,id, ignoreId)
{
  loadGlobals();

  var menuFile, theMenubar, i, menubarList;
  var tempArray = new Array();

  menuFile = new File(FILE_MENUXML_PATH);
  if (!menuFile.exists)
  {
    menuFile.setPath(FILE_CONFIG_PATH + '/Menus/menus.bak');
    menuFile.copyTo(FILE_MENUXML_PATH);
  }
  menuFile.setPath(FILE_MENUXML_PATH);
  menubarList = MENU_DOM.getElementsByTagName(tagName);
  theMenubar = getMenuTagByID(menubarList,id);

  // Call into the C++ layer to read the menus.xml file into our desired html 
   // This call traverses the menus in the menubar node and creates treenodes
   // Returns an object with nodes, and parallel arrays of nodenames and keys
  // Since snippets are now included in the shortcut list, and should be 
  // displayed under it's own category, ignore all snippet tags found under
  // the shortcutlist.
  var treeData = dw.getMenuTree(FILE_MENUXML_PATH, tagName, id, ignoreId);
  
  // It's possible in theory, although highly unlikely, to get NULL back from getMenuTree(),
  // so fail gracefully and return an empty list, and bypass adding stuff to the shortcut list
  if(treeData == null)
	return (new Array());

  var nodes = treeData.nodes;

  // Use the nodename and keys stuff from the C++ call to populate our shortcutlists too
  addShortcutsFromTree(treeData);

  return nodes;
}



// function returns the NodeList for the specified tag (it assumes that menus.xml exists).
// Returns null if the tag does not exists.
function getMenuTagByID(menubarList,id)
{
  var   i;
  var found = false;
  for(i=0;i<menubarList.length; i++)
  {
    if  ((menubarList[i].nodeType==Node.ELEMENT_NODE) && (menubarList[i].getAttribute("id") == id))
    {
      found = true;
      break;
    }
  }
  return (found)?menubarList[i]:null;
}

// changes the treecontrol when user has selected a different Commands set
function setCommands()
{
  findObject("theTreeControl").innerHTML = ARRAY_COMMANDS_TREE[MENU_COMMANDS.getIndex()];
}

// changes the itemList to show the shortcuts for the select tree node
function setShortcutList()
{
  var keyStr="", index, theValue, theSelectedNode;
  theSelectedNode = findObject("theTreeControl").selectedNodes[0];
  if (theSelectedNode)
  {
    theValue = theSelectedNode.value;
    index = theValue.lastIndexOf("|");
    if (index != -1)
      keyStr = theValue.substring(index+1);
  }
  if (keyStr)
    LIST_SHORTCUTS.setAll(keyStr.split(","));
  else
    LIST_SHORTCUTS.setAll(new Array());
  LIST_SHORTCUTS.setIndex(0);
}

// updates the key column of the selected treenode
function setShortcutInTree(selectedNode,oldKey,newKey, conflictID)
{
  var  index, treeNodeValue,numUpdates,keyStr;
//  keyStr = LIST_SHORTCUTS.list.toString();
  if (selectedNode)
  {
    numUpdates=CURRENT_SHORTCUT_LIST.update(selectedNode.name, convertKeyStr(newKey,"store"),convertKeyStr(oldKey,"store"));
    keyStr = convertKeyStr(CURRENT_SHORTCUT_LIST.getKeyByID(selectedNode.name),"display")
    treeNodeValue = selectedNode.value;
    if (treeNodeValue.search(/\|/)!=-1){
      treeNodeValue = treeNodeValue.replace(/\|.*/,"|"+keyStr);
    }else
      treeNodeValue += "|"+keyStr;
    selectedNode.setAttribute("value",treeNodeValue);
  }
  else
  {
    numUpdates=1+CURRENT_SHORTCUT_LIST.update(conflictID, convertKeyStr(newKey,"store"),convertKeyStr(oldKey,"store"));
  }

  if (numUpdates > 1)
  {
    ARRAY_COMMANDS_TREENODES = updateTreeNodeArray(ARRAY_COMMANDS_TREENODES);
  generateTreeArray();
//  setCommands();
  dw.forceGarbageCollection();
  }
  else
    ARRAY_COMMANDS_TREE[MENU_COMMANDS.getIndex()] = findObject("theTreeControl").innerHTML;
//  document.newShortcutEntry.setAttribute("value", "");
  // *** it would be nice to set A_C_T before user changes commands set instead

}

function writeToMenusXML(theShortcutList)
{
  loadGlobals();

  var i, keyStr, keyArray=new Array(), theId, menuBarNode, menuNode, altId, tempNode, shortcutNode;
  var menuitemList, shortcutItemList, shortcutTagList, menuFile, snippetShortcutTagList;

  menuitemList = MENU_DOM.getElementsByTagName("menuItem");
  shortcutItemList = MENU_DOM.getElementsByTagName("shortcut");
  shortcutTagList = MENU_DOM.getElementsByTagName("shortcutlist");
  snippetShortcutTagList = MENU_DOM.getElementsByTagName("snippets");   //TODO: make sure this is the right tag name - there should only be one of these

  for (i=0;i<theShortcutList.idKeyPairList.length; i++ )
  {
    keyArray = theShortcutList.idKeyPairList[i].keysArray;

    theId = theShortcutList.idKeyPairList[i].id;

	var bIsSnippet = false;
	
    if (theId && theShortcutList.changeList[theId])
    {
      //set the primary key

      //first check to see if this is a snippet shortcut
     if (theId.indexOf("Snippets*") == 0){  
		 bIsSnippet = true;
		 shortcutNode = getMenuTagByID(shortcutItemList, theId);
		 if (shortcutNode){

			if (keyArray[0])
				shortcutNode.setAttribute("key", keyArray[0]);
			else
				shortcutNode.setAttribute("key", "");
		 }
		 else {  //the shortcut tag does not exist in menus.xml so we need to add it
			tempNode = getMenuTagByID(snippetShortcutTagList, "DWSnippetsContext");  //TODO: need to verify that this is the right ID
			if (tempNode){
				var keyStr = (keyArray[0]!=null) ? keyArray[0] : "";
				tempNode.innerHTML += createSnippetShortcutTag(theId, keyStr);
			}
		 }
      }
      else {
		if (theId.indexOf("DWShortcut") == -1){
			menuNode = getMenuTagByID(menuitemList, theId);
			if (!menuNode) 
				menuNode = getMenuTagByID(shortcutItemList, theId);
		}
		else{
			menuNode = getMenuTagByID(shortcutItemList, theId);
			if (!menuNode) 
				menuNode = getMenuTagByID(menuitemList, theId);
		}
		if (menuNode != null && menuNode.getAttribute("key")!= keyArray[0]){
			if (keyArray[0])
				menuNode.setAttribute("key", keyArray[0]);
			else
				menuNode.setAttribute("key", "");
		}
	}
    //set Alternate key
	if (!bIsSnippet)
	{
		shortcutTagID = getTagIdFromItemId(theId,menuNode);
		if (shortcutTagID == "DWMainWindow1")
		{
			rightId = theId.replace(/DWMenu_/,"");
			altId = "DWShortcuts_" + rightId;
			shortcutTagID = shortcutTagID.substr(0,shortcutTagID.length-1);
		}
		else if (shortcutTagID == "DWMainSite1")
		{
			rightId = theId.replace(/DWMenu_MainSite/,"");
			altId = "DWShortcuts_MainSite" + rightId;
			shortcutTagID = shortcutTagID.substr(0,shortcutTagID.length-1);
		}
		else
		{
			altId = theId+"2";
		}
		if (keyArray.length > 1 && menuNode)
		{
			if (getMenuTagByID(shortcutItemList, altId) == null)   // check to see if alt already exists
			{
				tempNode = getMenuTagByID(shortcutTagList, shortcutTagID)
				if (tempNode)
					tempNode.innerHTML += createAltShortcutTag(menuNode, altId, keyArray[1]);
			}
			else
			{
				menuNode = getMenuTagByID(shortcutItemList, altId);
				if (menuNode)
					menuNode.setAttribute("key", keyArray[1]);
				if (menuNode.getAttribute("platform")==OPP_PLATFORM)
					menuNode.setAttribute("platform", "");
			}
		}
		else if ((menuNode = getMenuTagByID(shortcutItemList, altId)) != null)
		{
			if (menuNode.getAttribute("platform")!=OPP_PLATFORM)
			menuNode.setAttribute("key", "");
		}
            }	
	}
  }
  menuFile = new File(FILE_MENUXML_PATH);

  if (dreamweaver.appVersion && (dreamweaver.appVersion.indexOf('ja') != -1 || 
								 dreamweaver.appVersion.indexOf('ko') != -1 ||
								 dreamweaver.appVersion.indexOf('zh') != -1) )
    menuFile.setContents(MENU_DOM.body.outerHTML);
  else
    menuFile.setContents(dreamweaver.nativeToLatin1(MENU_DOM.body.outerHTML));
}

function createAltShortcutTag(origNode, newId, newKey)
{

  var retVal = new Array(), value;
  var attrArray  = new Array("file","command","domRequired","arguments","enabled","name")
  retVal.push(NEWLINE + "    <shortcut key=" + '"' + newKey + '"');
  for (var i=0; i<attrArray.length; i++)
  {
    if ((value = origNode.getAttribute(attrArray[i])))
      retVal.push("   "+attrArray[i]+"=" + '"' + value + '"');
  }
  retVal.push("   id=" + '"' + newId + '" />'+NEWLINE);
  return retVal.join("");
}

function createSnippetShortcutTag( newId, newKey)
{
	//remember to replace \ with / in path code insertSnippet command
  var retVal = new Array();
  var relPath;
  relPath = convertSnippetIDtoRelPath(newId)
  retVal.push(NEWLINE + "        <SHORTCUT key=" + '"' + newKey + '"');
  retVal.push ("  " + "domRequired=" +'"' + 'FALSE' + '"');
  retVal.push ("  " + "command=\"dw.snippetPalette.insertSnippet(" + "'" + relPath + "')\"" );
  retVal.push("   id=" + '"' + newId + '" />'+NEWLINE);
  return retVal.join("");
}

function convertSnippetIDtoRelPath(theID)
{
	// convert an ID that looks like... Snippets*Custom*rubberducky.csn to Snippets\\Custom\\rubberducky.csn
	var relPath;
	var snippetPrefix = "Snippets*"
	theID = theID.substring(snippetPrefix.length);
	relPath = theID.replace(/\*/g,"\\\\" );
	return relPath;
}

// Given an items it, returns the id of the menubar id
function getTagIdFromItemId(itemId,menuNode)
{
  var retVal="",parent, parentId;
  parent = menuNode.parentNode;
  if (menuNode)
  {
    if (parent.tagName =="SHORTCUTLIST")
      retVal = parent.getAttribute("id");
    else
    {
      while (parent && !parentId)
      {
        if (parent.tagName =="MENUBAR")
          parentId = parent.getAttribute("id");
        else
          parent = parent.parentNode;
      }
    }
    if (parentId)
    {
      if (parentId =="DWMainSite")
        retVal = "DWMainSite1"
      else if (parentId =="DWMainWindow")
        retVal = "DWMainWindow1"
    }
  }
  return retVal;
}

function getAltKeyId(id)
{
 var retVal="";
 if (!id )
   return retVal;
 else if (id.indexOf("DWMenu_")!=-1)
   retVal = id.replace(/DWMenu_/,"DWShortcuts_");
 else if (id)
   retVal = id+"2";
 return retVal;
}

function isShortcutToExclude(id)
{
  var retVal=true,i, tempId;
  var idPrefixArray = new Array("DWShortcuts_Main_","DWShortcuts_Site_","DWShortcuts_HTMLSource_");
  if (id && id.indexOf("DWShortcuts")!=-1)
  {
  var tempId = (id.charAt(id.length-1)=="2") ? id.substring(0,id.length-1): "";
  if (tempId && CURRENT_SHORTCUT_LIST.getIndexByID(tempId) != -1)
    retVal = true;
  else
  {
      for (i=0;i<idPrefixArray.length;i++)
      {
        if (id && id.indexOf(idPrefixArray[i]) != -1)
        {
          retVal = false;
          break;
        }
      }
    }
  }
  else retVal=false;
  return retVal;
}

function getIndexOfItem(theArray,theItem)
{
  var index,found=false;
  for (index=0;index<theArray.length;index++)
  {
    if (theArray[index] == theItem)
    {
      found=true;
      break;
    }
  }
  return (found)? index:-1;
}

function updateUI(itemName)
{
  var newSetFile, newSetName, retVal, tempStr,errorMsg,selectedTreeNode,keyStr,oldKey,numUpdate,otherNode;
  var tempShortcutList;
  switch(itemName)
  {
    case "selectCurrentSet":
  {
    if (MENU_CURRENT_SET.get() == SEPARATOR_STR)
    {
        MENU_CURRENT_SET.pickValue(LAST_VALID_COMMAND_MI);
        //document.commandsList.focus()
    }
    else
    {
      if  (!isSet(MENU_CURRENT_SET.getValue(), "factory")
           && (CURRENT_SHORTCUT_LIST.changeListLength() > 0 )&& confirm(MSG_SaveShortcutSet))
      CURRENT_SHORTCUT_LIST.writeToShortcutXML(FILE_CUSTOM_SET+"/" + MENU_CURRENT_SET.getValue(), CURRENT_SHORTCUT_LIST.shortcutListName);
      MM.setBusyCursor();
      newSetFile = MENU_CURRENT_SET.getValue();
      if (getExtension(newSetFile) !="xml")
        newSetFile+=".xml"
      tempShortcutList = new ShortcutList();
      tempShortcutList.readFromShortcutXML(FILE_CUSTOM_SET+"/" + newSetFile);
      CURRENT_SHORTCUT_LIST.compareUpdate(tempShortcutList);
      ARRAY_COMMANDS_TREENODES = updateTreeNodeArray(ARRAY_COMMANDS_TREENODES);
      generateTreeArray();
      setCommands();
      dw.forceGarbageCollection();
      MM.clearBusyCursor();
    }
    LIST_SHORTCUTS.setAll("");
    clearField("newShortcutEntry");
    LAST_VALID_COMMAND_MI = MENU_CURRENT_SET.getValue();
    MENU_CURRENT_SET.focus()
    break;
  }
  case "duplicateBtn":
    {
    newSetName = callCommand("duplicate set",new Array(MENU_CURRENT_SET.getValue(),CURRENT_SHORTCUT_LIST));
    if (newSetName)
    {
      CURRENT_SHORTCUT_LIST.shortcutListName = newSetName;
      DWfile.write(FILE_ACTIVE_SET,newSetName);
      setCurrentSetMenu();
      MENU_CURRENT_SET.setIndex(getIndexOfItem(MENU_CURRENT_SET.get('all'),newSetName));
      updateUI("selectCurrentSet");
    }
    break;
    }
  case "renameBtn":
  {
    if (!isSet(MENU_CURRENT_SET.getValue(), "factory"))
    {
      newSetName = callCommand("rename set",MENU_CURRENT_SET.getValue());
      if (newSetName)
      {
        CURRENT_SHORTCUT_LIST.shortcutListName = newSetName;
        DWfile.write(FILE_ACTIVE_SET,newSetName);
        setCurrentSetMenu();
        MENU_CURRENT_SET.setIndex(getIndexOfItem(MENU_CURRENT_SET.get('all'),newSetName));
      }
    }
    else
      alert(MSG_CannotRenameFactorySet);
    break;
  }
  case "deleteBtn":
  {
    tempStr = CURRENT_SHORTCUT_LIST.shortcutListName;
    tempStr = tempStr.replace(/.xml/,"");
    retVal = callCommand("delete set",tempStr);
    if (retVal)
    {
      setCurrentSetMenu();
      MENU_CURRENT_SET.setIndex(getIndexOfItem(MENU_CURRENT_SET.get('all'),ACTIVE_SET_STR));
    }
    break;
  }
  case "commandsList":
  { // update the treecontrol
    if (MENU_COMMANDS.get() ==SEPARATOR_STR)
    {
      MENU_COMMANDS.setIndex(MENU_COMMANDS.getIndex()-1);
      updateUI("commandsList");
    }
    else
      setCommands();
    document.newShortcutEntry.setAttribute("value", "")
    updateUI("newShortcutEntry");
    LIST_SHORTCUTS.setAll("");
    break;
  }
  case "theTreeControl":
  {
    ARRAY_COMMANDS_TREE[MENU_COMMANDS.getIndex()] = findObject("theTreeControl").innerHTML;
    setShortcutList();
    clearField("newShortcutEntry");
    break;
  }
  case "addBtn":
  { // node.childNodes.length
    if (!isSet(MENU_CURRENT_SET.getValue(), "factory"))
    {
        selectedTreeNode = findObject("theTreeControl").selectedNodes[0];
      if (selectedTreeNode && selectedTreeNode.childNodes.length == 0 )
      {
        if ((LIST_SHORTCUTS.getLen()==0 || LIST_SHORTCUTS.get() !="" ) && LIST_SHORTCUTS.getLen() < 2)
        {
          LIST_SHORTCUTS.append();
          document.newShortcutEntry.focus();
          document.newShortcutEntry.select();
        }
    }
      }
    else
    {
      if (confirm (MSG_FactorySetCannotBeModified))
        updateUI("duplicateBtn");
    }
    break;
  }
  case "minusBtn":
  {
    if (findObject("theTreeControl").selectedNodes[0])
    {
      if (!isSet(MENU_CURRENT_SET.getValue(), "factory"))
      {
        if (LIST_SHORTCUTS.getLen!=0)
        {
          selectedTreeNode = findObject("theTreeControl").selectedNodes[0];
          oldKey = LIST_SHORTCUTS.get();
          
          if (oldKey)
            setShortcutInTree(selectedTreeNode,oldKey,"");
          
          LIST_SHORTCUTS.del();
          SNIPPETS_MODIFIED = true;
        }
      }
      else
      {
        if (confirm (MSG_FactorySetCannotBeModified))
          updateUI("duplicateBtn");
      }
    }
    break;
  }
  case "newShortcutEntry":
  {
    if (!document.newShortcutEntry.value || !isSet(MENU_CURRENT_SET.getValue(), "factory"))
    {
      errorMsg = checkKeyForConflict(convertKeyStr(document.newShortcutEntry.value,"store"));
      if(errorMsg)
      {
        findObject("warningMessage").innerHTML = errorMsg;
      }
      else if(findObject("warningMessage").innerHTML != "")
      {
          findObject("warningMessage").innerHTML = "";
      }
      }
      else
      {
      if (confirm (MSG_FactorySetCannotBeModified))
        updateUI("duplicateBtn");
    }
//    if (document.newShortcutEntry.value=="")
//    {
//        document.applyButton.setAttribute("disabled","true");
//    }
    break;
  }
  case "applyButton":
  {
    if (CAN_APPLY)
    {
      if (!isSet(MENU_CURRENT_SET.getValue(), "factory"))
      {
        selectedTreeNode = findObject("theTreeControl").selectedNodes[0];
        if (!selectedTreeNode || selectedTreeNode.childNodes.length != 0 )
          break;
        if (CONFLICT_ID && !confirm(errMsg(MSG_ReassignShortcut,getNameFromTreeArray(CONFLICT_ID),getNameFromTreeArray(document.theTreeControl.selectedNodes[0].name))))
          break;
        else
        {
          if (CONFLICT_ID)
          {
//            CURRENT_SHORTCUT_LIST.update(CONFLICT_ID,"",convertKeyStr(document.newShortcutEntry.value,"store"));
            otherNode = document.theTreeControl[CONFLICT_ID];
            if (otherNode)
              setShortcutInTree(otherNode,document.newShortcutEntry.value,"")
            else
              setShortcutInTree(null,document.newShortcutEntry.value,"",CONFLICT_ID);
          }
          if (LIST_SHORTCUTS.getLen() == 0)
            LIST_SHORTCUTS.add("");
          oldKey = LIST_SHORTCUTS.get();
          LIST_SHORTCUTS.set(document.newShortcutEntry.value);
          setShortcutInTree(selectedTreeNode,oldKey,document.newShortcutEntry.value);
        }
      }
      else
      {
        if (confirm (MSG_FactorySetCannotBeModified))
          updateUI("duplicateBtn");
      }
      document.newShortcutEntry.setAttribute("value", "")
      updateUI("newShortcutEntry");
      SNIPPETS_MODIFIED = true;
    }
    dw.forceGarbageCollection();
    break;
  }
  }
}

function generateTreeControlHtml(treeNodesArray)
{
  var retVal = new Array();
  var treeControlTag = 'MM:TREECONTROL';
  var treeColumnTag = 'MM:TREECOLUMN';
  var treeColWidth = (PLATFORM=="Win32") ? TREE_COLUMN_ITEM_WIDTH : TREE_COLUMN_ITEM_WIDTH_MAC;
  retVal.push( "  <" + treeColumnTag + ' name="menuitems" ' + TREE_COLUMN_ITEM_WIDTH + '>' + NEWLINE);
  retVal.push("  <" + treeColumnTag + ' name="shortcutKeys" ' + TREE_COLUMN_KEY_WIDTH + '>' + NEWLINE);
  if (treeNodesArray)
	 retVal.push(treeNodesArray.join(""));
  return retVal.join("");
}

function generateTreeArray()
{
  var i=0;
  if (ARRAY_COMMANDS_TREE.length==0)
    ARRAY_COMMANDS_TREE.length = ARRAY_COMMANDS_TREENODES.length;
  for (i=0;i<ARRAY_COMMANDS_TREENODES.length;i++)
  {
    if (ARRAY_COMMANDS_TREENODES[i] !="-")
      ARRAY_COMMANDS_TREE[i]=generateTreeControlHtml(ARRAY_COMMANDS_TREENODES[i]);
    else
      ARRAY_COMMANDS_TREE[i] = "-";
  }
}

function updateTreeNodeArray(arrayOfTreeNodeArrays)
{
  var i, x, theNodeStr;
  for (i=0; i < arrayOfTreeNodeArrays.length; i++)
  {
    for (x=0; x <  arrayOfTreeNodeArrays[i].length; x++)
    {
      theNodeStr = updateTreeNode(arrayOfTreeNodeArrays[i][x]);
      if (theNodeStr != arrayOfTreeNodeArrays[i][x]);
        arrayOfTreeNodeArrays[i][x] = theNodeStr;
    }
  }
  return arrayOfTreeNodeArrays;
}

function updateTreeNode(treeNodeStr)
{
  var startIndex=0, keyStr, newStr, endIndex=0;
  if (treeNodeStr.indexOf('name="DW') !=-1)
  {
    startIndex = treeNodeStr.indexOf('name="DW',startIndex)+6;
    endIndex = treeNodeStr.indexOf('"',startIndex);
    theId = treeNodeStr.substr(startIndex, endIndex-startIndex);

    // get keyStr for the given id
    keyStr = convertKeyStr(CURRENT_SHORTCUT_LIST.getKeyByID(theId),"display");
  if(treeNodeStr.indexOf("|"+keyStr+'"') == -1 ||!keyStr && treeNodeStr.indexOf("|")!=-1)
    {
      startIndex=treeNodeStr.indexOf("|");
      if (startIndex==-1)
      {
        startIndex = treeNodeStr.indexOf('value="')+7;
        startIndex = treeNodeStr.indexOf('"',startIndex);
      }
      endIndex = treeNodeStr.indexOf('"', startIndex);
      newStr = treeNodeStr.substr(0, startIndex);
      if (keyStr) newStr += "|";
        newStr += keyStr + treeNodeStr.substr(endIndex);
      treeNodeStr = newStr;
    }
  }
  return treeNodeStr;
}

function setCurrentSetMenu()
{
  var factorySets = getCustomSetList("factory");
  var customSets = getCustomSetList("custom");
  if (customSets[0].length !=0){
    factorySets[0].push(SEPARATOR_STR);
    factorySets[1].push(SEPARATOR_STR);
  }
  var currentSetNames = factorySets[0].concat(customSets[0]);
  var currentSetFiles = factorySets[1].concat(customSets[1]);

  ACTIVE_SET_STR = DWfile.read(FILE_ACTIVE_SET);
  MENU_CURRENT_SET.setAll(currentSetNames,currentSetFiles);
}

function isKeyWithoutCtrl(theKey)
{
  var retVal=false;
  if (theKey.length == 1)
    retVal = true;
  else
  {
    index = theKey.lastIndexOf("+");
    tempStr = theKey.substring(index+1);
    if (PLATFORM=="Win32")
    {
      if (tempStr.length == 1 && theKey.indexOf("Cmd") == -1 && theKey.indexOf("Ctrl") == -1)
        retVal = true;
    }
    else 
    {
      if (tempStr.length == 1 && theKey.indexOf("Cmd") == -1)
        retVal = true;
    }
  }
  return retVal;
}

// returns error message if the given shortcut key is invalid
function checkKeyForConflict(newKey)
{
  var retVal, conflictId;
  if (newKey)
    conflictId = CURRENT_SHORTCUT_LIST.getIdByKey(newKey);
  if (PLATFORM == "Win32" && conflictId == "" && newKey.indexOf("Cmd") != -1)
  {
  	newKey = newKey.replace(/Cmd/,"Ctrl");
  	conflictId = CURRENT_SHORTCUT_LIST.getIdByKey(newKey);
  }
  	
  CONFLICT_ID = conflictId;
  if (isKeyWithoutCtrl(newKey))
  {
    retVal = createWarningMsg();
    CAN_APPLY = false;
//    document.applyButton.setAttribute("disabled","true");
  }
  else
  {
//    document.applyButton.removeAttribute("disabled");
    CAN_APPLY = true;
    if (conflictId)
      retVal = createWarningMsg(getNameFromTreeArray(conflictId));
    else
      retVal="";
  }
  return retVal;
}

function createWarningMsg(theId)
{
  var retVal = new Array();
  if (theId)
  {
    imagePath = YIELD_PATH;
    messageStr = MSG_ShortcutAssigned;
    errorMsgArg = theId;
  }
  else
  {
    imagePath = STOP_PATH;
    messageStr = MSG_LetterShortcutMustHaveCtrl;
    errorMsgArg = CTRL_STR;
  }
  retVal.push('<img src="'+ imagePath + '" width="12" height="12" >');
  retVal.push(errMsg(messageStr, errorMsgArg));
  return retVal.join("");
}


function isSet(setFileName, setType)
{
  var facSetArray = new Array(), i, retVal = false;
  facSetArray = getCustomSetList(setType)[1];
  if (setFileName.lastIndexOf(".xml") != setFileName.length-4)
    setFileName = setFileName + ".xml";
  for (i=0; i<facSetArray.length; i++)
  {
    if (facSetArray[i] == setFileName)
    {
      retVal = true;
      break;
    }
  }
  return retVal;
}

function createHTMLContents()
{
  var retVal = new Array(), i, treeNodeStr, keyStr,currLevel;
  var nextNodeStr="",isBold,tempNodeStr;
  var closeTreeNodeStr='</MM:TREENODE>'+ NEWLINE;
  retVal.push("<HTML>"+NEWLINE+"<HEAD>");
  retVal.push("<TITLE>" + CURRENT_SHORTCUT_LIST.shortcutListName + " Shortcut Set" + "</TITLE>" +NEWLINE);
  retVal.push('<style type="text/css">\n<!--\nbody {font-family:  '  + cssfontStr + '; text-align: center}\ntable {  font-size: x-small}\n-->\n</style>')
  retVal.push("</HEAD>"+NEWLINE);
  retVal.push('<BODY BGCOLOR="#FFFFFF">');
  retVal.push('<DIV ALIGN="center">');
  retVal.push('<p><b><font size="6">'+ MENU_CURRENT_SET.get()+'</font></b></p>\n<p><b>' + DW_VERSION + '</b></p>')
  ARRAY_COMMANDS_TREENODES = updateTreeNodeArray(ARRAY_COMMANDS_TREENODES);
  for (i=0;i<ARRAY_COMMANDS_TREENODES.length;i++)
  {
    if (ARRAY_COMMANDS_TREENODES[i]!="-")
    {
      retVal.push("<p><b>"+MENU_COMMANDS.get(i)+"</b></p>"+NEWLINE);
      retVal.push('<TABLE border = "1" cellspacing="0" cellpadding="2">'+NEWLINE);
      for(x=0;x<ARRAY_COMMANDS_TREENODES[i].length;x++)
      {
        treeNodeStr = ARRAY_COMMANDS_TREENODES[i][x];
        for (var k=x+1;k<ARRAY_COMMANDS_TREENODES[i].length;k++)
        {
        tempNodeStr = ARRAY_COMMANDS_TREENODES[i][k];
        if (tempNodeStr != closeTreeNodeStr){
        nextNodeStr = tempNodeStr;
          break;
      }
      }
        currLevel = getTreeNodeLevel(treeNodeStr);
        isBold = (nextNodeStr && (getTreeNodeLevel(nextNodeStr) > currLevel))
        if (treeNodeStr != closeTreeNodeStr)
      {
          retVal.push("<TR>"+NEWLINE);
        retVal.push("<TD>");
        for(var j=0; j<currLevel*4; j++)
          retVal.push("&nbsp;")
        if (isBold)
          retVal.push("<b>");
        retVal.push(getTreeNodeValue(treeNodeStr,1))
        if (isBold)
          retVal.push("</b>");
        retVal.push("</TD>"+NEWLINE);
        keyStr = getTreeNodeValue(treeNodeStr,2);
        if (!keyStr) keyStr = "&nbsp;";
        retVal.push("<TD>"+keyStr+"</TD>"+NEWLINE);
        retVal.push("</TR>"+NEWLINE);
      }
      }
      retVal.push("</TABLE>");
    }
  }
  retVal.push("</div>"+NEWLINE + "</BODY>"+NEWLINE+"</HTML>");
  return retVal.join("");
}

function getTreeNodeValue(treeNodeStr,column)
{
  var startIndex, endIndex, valueStr, valueArray, retVal ="";
  startIndex = treeNodeStr.indexOf('value="')+7;
  endIndex = treeNodeStr.indexOf('"', startIndex);
  valueStr = treeNodeStr.substring(startIndex,endIndex);
  valueArray = valueStr.split("|");
  if (valueArray.length >= column)
  retVal = valueArray[column-1];
  return retVal;
}

function getTreeNodeLevel(treeNodeStr)
{
  var startIndex, endIndex, valueStr="0", valueArray;
  startIndex = treeNodeStr.indexOf('level="')+7;
  endIndex = treeNodeStr.indexOf('"', startIndex);
  valueStr = treeNodeStr.substring(startIndex,endIndex);
  return (valueStr) ? valueStr : 0;
}

function getSimpleName(filenameArray)
{
  var i;
  for (i=0;i<filenameArray.length;i++)
  {
    if (filenameArray[i].lastIndexOf(".xml") == filenameArray[i].length-4)
      filenameArray[i] = filenameArray[i].replace(/.xml/,"");
  }
  return filenameArray;
}

function getExtension(fileName)
{
  var retVal = "", index;

  index = fileName.lastIndexOf(".");
  if (index != -1)
    retVal = fileName.substring(index+1);
  return retVal;
}

function getSimpleFileName(fileName)
{
  var index; retVal = fileName;

  index = fileName.lastIndexOf(".");
  if (index != -1)
    retVal = fileName.substring(0,index);
  return retVal;
}

function convertKeyStr(keyStr,location)
{
  var retVal=keyStr;
  if (PLATFORM=="Win32")
  {
    if (location === "display")
    {
      if (retVal.indexOf("Cmd")!=-1)
        retVal = retVal.replace(/Cmd/g,"Ctrl");
      if (retVal.indexOf("Opt")!=-1)
        retVal = retVal.replace(/Opt/g,"Alt");
    }
    if (location  == "store")
    {
      if (retVal.indexOf("Ctrl")!=-1)
        retVal = retVal.replace(/Ctrl/g,"Cmd");
      if (retVal.indexOf("Alt")!=-1)
        retVal = retVal.replace(/Alt/g,"Opt");
    }
  }
  return retVal;
}

function getPressedKeys()
{
  var eventObj = window.event;
  var retVal = new Array();
  var theKeyCode = eventObj.keyCode;
  var charCode = dw.mapKeyCodeToChar(theKeyCode);
  var keyStr = KEY_CODES[theKeyCode];
  var modifierFound = false, nonModifier=false;
  if (eventObj.ctrlKey)
    retVal.push("Ctrl");
  if (eventObj.cmdKey)
    retVal.push("Cmd");
  if (eventObj.altKey)
    retVal.push(ALT_STR);
  if (eventObj.shiftKey)
    retVal.push("Shift");
  if (keyStr)
  retVal.push(keyStr);
  else if (charCode !=0)
    retVal.push(String.fromCharCode(charCode));

  // allow tab and shift-tab to move cursor in and out off newShortcutEntry
  if (retVal.length == 1 && keyStr == "Tab"){
		  document.theForm.applyButton.focus();
		  return false;
  }

  if (retVal.length == 2 && retVal[0]== 'Shift' && keyStr == "Tab"){
		  document.theForm.itemList.focus();
		  return false;
  }

  for (var i=0; i<retVal.length; i++)
  {
  modifierFound=false;
    for (var j=0; j<MODIFIER_KEYS.length; j++)
    {
      if (MODIFIER_KEYS[j]== retVal[i])
      {
    modifierFound = true;
      break;
    }
  }
  if (!modifierFound)
  {
      nonModifier=true;
    break;
    }
  }
  if (retVal[0] && nonModifier)
    document.newShortcutEntry.value = (retVal.length > 1) ? retVal.join("+") : retVal[0];
  else
    document.newShortcutEntry.value = "";
  return false;
}

function clearField(objName)
{
  document[objName].value = "";
  updateUI(objName);
}

function getNameFromTreeArray(id)
{
  var i,x, startIndex, endIndex, pipeIndex, idFound, retVal="";

  for (i=0; i<ARRAY_COMMANDS_TREENODES.length; i++)
  {
    for (x=0; x<ARRAY_COMMANDS_TREENODES[i].length; x++)
    {
      nodeStr = ARRAY_COMMANDS_TREENODES[i][x];
      startIndex = nodeStr.indexOf('name="') + 6;
      if (startIndex >=6)
      {
        endIndex=nodeStr.indexOf('"',startIndex);
      nodeName=nodeStr.substring(startIndex, endIndex);
      }
      if (nodeName == id)
      {
        startIndex=nodeStr.indexOf('value="') + 7;
        if (startIndex >= 7)
        {
          pipeIndex = nodeStr.indexOf("|", startIndex);
          endIndex = (pipeIndex == -1) ? nodeStr.indexOf('"',startIndex) : pipeIndex;
          retVal = nodeStr.substring(startIndex, endIndex);
        }
        idFound=true;
        break;
      }
    }
    if (idFound)
      break;
  }
  return retVal;
}

function checkLockedFiles()
{
  loadGlobals();

  retVal = false;
  fileArray = new Array(FILE_MENUXML_PATH,FILE_ACTIVE_SET);
  for (var i=0;i<fileArray.length; i++)
  {
    if (DWfile.getAttributes(fileArray[i])=="R")
    {
      alert(errMsg(MSG_ReadOnlyFile,fileArray[i]));
      retVal=true;
    }
  }
  return retVal;
}

function addShortcutsFromTree(treeData) {
	var numElts = treeData.names.length;
	for(var i=0; i < numElts; i++){
		 CURRENT_SHORTCUT_LIST.addShortcut( treeData.names[i],  treeData.keys[i]);
	}
	return;
}

